# Planning, Rehabilitated: Moving by Magnetic North

## 1. The Tragedy of Earnest Plans

Enormous amounts of time—personal, organizational, civilizational—are wasted not because people fail to plan, but because they **faithfully execute plans that were doomed from the beginning**.

Doomed not by incompetence.
Not by bad intentions.

But by a simple impossibility:

> The actual destination could not have been known at the start.

Yet we pretend otherwise.

We treat early guesses as truths.
We bind ourselves to artifacts created under radically incomplete information.
And then we spend years honoring those commitments out of obligation, identity, or fear of incoherence.

This is not discipline.
It is inertia wearing a virtue costume.

---

## 2. Why Planning Gets Blamed for the Wrong Crime

When people eventually burn out, disengage, or rebel, planning takes the blame.

“Plans kill creativity.”
“Planning is rigid.”
“Planning doesn’t work for complex lives.”

But planning isn’t the villain.

**Static direction is.**

Planning fails when it is asked to do something it cannot do:
- discover meaning
- predict emergence
- lock in destinations that require exploration to even perceive

This is like demanding a map before the terrain has surfaced.

---

## 3. The False Idol of ‘True North’

Many planning philosophies rely on a seductive metaphor: *true north*.

A fixed orientation.
A life mission.
A singular purpose that, once discovered, aligns everything else.

For some narrow contexts, this works.

But for living systems, it creates damage.

Because it assumes:
- the destination exists in advance
- it can be named early
- it will remain stable

In reality, meaning is not a pole.

It is a **field**.

---

## 4. Magnetic North: A Better Metaphor

A more accurate guide is **magnetic north**.

Magnetic north:
- is real
- exerts pull
- can be measured
- *moves over time*

Navigators do not curse magnetic north for drifting.
They correct for it.

They understand that:
- orientation is dynamic
- recalibration is normal
- drift is expected

Living well requires the same humility.

The question is not:

> “What is my true north?”

But:

> “What is pulling *now*?”

---

## 5. Planning’s Proper Job

Planning, rehabilitated, has a precise and limited role.

Plans are excellent at:
- allocating resources
- sequencing actions
- coordinating across people
- reducing friction once direction exists

Plans are terrible at:
- choosing destinations in unknown terrain
- substituting for pull
- freezing direction prematurely

Planning should **serve motion**, not dictate it.

---

## 6. Attractors as Moving Targets

Pull does not point to a fixed endpoint.

It points along a gradient.

Attractors:
- strengthen or weaken
- split into sub-attractors
- merge with others
- disappear once exhausted

This is not instability.

It is learning.

Treating attractors as fixed goals destroys them.
Treating them as signals preserves vitality.

---

## 7. The Cost of Obedience to Dead Plans

When plans outlive pull, systems respond predictably:

- motivation is replaced by compliance
- curiosity is replaced by justification
- effort is replaced by force

At scale, this produces:
- organizations executing irrelevant strategies
- people climbing ladders leaning against empty walls
- institutions defending outcomes no one wants anymore

The waste is not just time.

It is human aliveness.

---

## 8. Recalibration Is Not Failure

In a magnetic-north model, changing course is not betrayal.

It is competence.

Updating plans in response to new pull is not inconsistency.

It is responsiveness.

The only failure is pretending nothing has changed when everything has.

---

## 9. A Simple Planning Upgrade

Before making or renewing a plan, ask:

> “What attractor is this plan currently serving?”

If the answer is unclear, outdated, or absent:
- pause the plan
- reduce its scope
- return to exposure

Plans without attractors should be provisional at best.

---

## 10. Planning, Finally on Your Side

Rehabilitated planning is lighter.

It assumes:
- incomplete knowledge
- moving targets
- ongoing recalibration

It does not demand certainty.
It does not moralize deviation.

It works *with* life instead of against it.

---

*Do not orient your life by a pole that cannot move.*

*Move by magnetic north.*

*Let plans follow pull, not replace it.*
